<?php defined('PF_VERSION') OR exit('Access denied');?>
<?php

/*
 * 
 * @package  PageFlex
 * @author  PageFlex Team (technical@vinamost.net)
 * @copyright PageFlex Team
 * @link  http://page-flex.com
 * @since  Version 1.0
 * @filesource
 *
 */
$ref=array('admin-page'=>'users');
if(!empty($_GET['page'])) $ref['page']  =   $_GET['page'];
if(!empty($_GET['username'])) $ref['username']    =   $_GET['username'];
if(!empty($_GET['email'])) $ref['email']    =   $_GET['email'];
if(!empty($_GET['role'])) $ref['role']    =   $_GET['role'];
if(!empty($_GET['active'])) $ref['active']    =   $_GET['active'];
if(!empty($_GET['publish'])) $ref['publish']    =   $_GET['publish'];
$create = new Pf_User();
$show = '';
$formname = __("New User", "user");
$class = $create;
$active =   true;
$public =   true;
$settings = Pf::setting();
$min_user = $settings->get_element_value('pf_user', 'user_length');
$min_pass = $settings->get_element_value('pf_user', 'pass_length');
if (isset($_POST['user-name'])) {
    $displayname = isset($_POST['displayname']) ? htmlspecialchars($_POST['displayname']) : '';
    $role = isset($_POST['role']) ? $_POST['role'] : 5;
    $v = Pf::validator();
    $_POST = $v->sanitize($_POST);
    $v->validation_rules(array(
        "user-name" => "required|alpha_numeric|max_len,20|min_len,{$min_user}",
        "user-email" => "required|valid_email",
        "password" => "required|max_len,20|min_len,{$min_pass}",
        "repassword" => "required|max_len,20|min_len,{$min_pass}"
    ));
    $v->filter_rules(array(
        'user-name' => 'trim|sanitize_string',
        'password' => 'trim',
        'user-email' => 'trim|sanitize_email'
    ));
    $validate = $v->run($_POST);


    if ($validate === false) {
        $error = $v->get_readable_errors(false);
    } else {
        $email = $_POST['user-email'];
        $username = $_POST['user-name'];
        $password = $_POST['password'];
        $repassword = $_POST['repassword'];
        $active= !empty($_POST['activation'])?1:2;
        $public= isset($_POST['public_profile'])?1:2;
        if (!$create->check_email($email) > 0) {
            $error['user-email'][0] = __("Email is already in use!", "user");
        }
        if (!$create->check_user($username)) {
            $error['user-name'][0] = __("Username is already in use!", "user");
        }
        if ($password != $repassword) {
            $error['repassword'][0] = __("Passwords do not match!", "user");
        }
    }
    if (isset($error)) {
        $show.=notif(__("Please review your information!", "user"));
    } else {
        $create->add_data(array(
            'user-email'=>$email,
            'user-name'=>$username,
            'displayname'=>$_POST['displayname'],
            'password'=>$password,
            'activation'=>$active,
            'role'=>$_POST['role'],
            'public'=> $public,
        ));
        $create->set_activation_key();
        $create->send_mail = TRUE;
        $create->save();
        $show.=notif(__("User is created successfully!", "user"));
        $_SESSION['success']=__('User is created successfully!','user');
        header('location: ?admin-page=users');
    }
}
require_once abs_plugin_path(__FILE__) . "/user/views/views-form.php";
